/* fclose function */
#include <stdlib.h>
#include "xmtx.h"
#include "xstdio.h"
#include "yfuns.h"
_STD_BEGIN

static _Once_t closeallreg_o = _ONCE_T_INIT;

static void closeall(void)
	{	/* close all files at exit */
	size_t i;

	for (i = 0; i < FOPEN_MAX; ++i)
		if (_Files[i] != 0)
			fclose(_Files[i]);
	}

static void closeallreg(void)
	{	/* register closeall with _Atexit */
	_Locksyslock(_LOCK_STREAM);	/* lock cleanup must be registered first! */
	_Atexit(&closeall);
	_Unlocksyslock(_LOCK_STREAM);
	}

void _Closreg(void)
	{	/* make sure closeall is registered */
	_Once(&closeallreg_o, closeallreg);
	}

int (fclose)(FILE *str)
	{	/* close a stream */
	int stat;

	if ((str->_Mode & (_MOPENR | _MOPENW)) == 0
		|| !_FD_VALID(str->_Handle))
		return (EOF);	/* doesn't look like valid open file */
	stat = fflush(str);
	_Locksyslock(_LOCK_STREAM);
	if (str->_Mode & _MALBUF)
		free(str->_Buf);
	str->_Buf = 0;
	if (_Fclose(str))
		stat = EOF;
	if (str->_Tmpnam != 0)
		{	/* remove temp file */
		if (remove(str->_Tmpnam))
			stat = EOF;
		free(str->_Tmpnam), str->_Tmpnam = 0;
		}
	if (str->_Mode & _MALFIL)
		{	/* find _Files[i] entry and free */
		size_t i;

		for (i = 0; i < FOPEN_MAX; ++i)
			if (_Files[i] == str)
				{	/* found entry */
				_Files[i] = 0;
				break;
				}
		free(str);
		}
	else
		{
		str->_Mode = 0;
		str->_Handle = _FD_INVALID;
		str->_Buf = &str->_Cbuf;
		str->_Next = &str->_Cbuf;
		str->_Rend = &str->_Cbuf, str->_WRend = &str->_Cbuf;
		str->_Wend = &str->_Cbuf, str->_WWend = &str->_Cbuf;
		str->_Rback = str->_Back + sizeof (str->_Back);
		str->_WRback = str->_WBack
			+ sizeof (str->_WBack) / sizeof (wchar_t);
		}
	_Unlocksyslock(_LOCK_STREAM);
	return (stat);
	}
_STD_END

/*
 * Copyright (c) 1992-2003 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V4.02:1422 */
